call spMante_Conductor('NEW', NULL, 'camion fuso', 0, 'tarjpro', 'sw8085', '1985', NULL, NULL, NULL, NULL, 1);
 
DROP PROCEDURE IF EXISTS spMante_Conductor;
CREATE PROCEDURE spMante_Conductor(
	varOpcion     varchar(10),
	varCodigo     int,
	varNombre     varchar(80),
	varDni        varchar(8),
  varBrevete    varchar(20),
  varTelefono   varchar(20),
  varCosto      double,
  varEstado     char(1),
	varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then    
    select count(*) INTO varExiste from _sv_conductor 
    where _estado = 'A' 
    and (TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) or TRIM(UPPER(dni)) = TRIM(UPPER(varDni)));
    
    if varExiste <= 0 then 
      
      SELECT ifnull(max(id_conductor),0)+1 INTO varCodigo FROM _sv_conductor;    
      
      INSERT INTO _sv_conductor (id_conductor, nombre, dni, brevete, telefono, monto, estado,
                                _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varDni, UPPER(varBrevete),  varTelefono, varCosto, varEstado, 
              NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL CONDUCTOR ', varNombre, ' \nO EL DNI ', varDni, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;    	
	else
    
    select count(*) INTO varExiste  from _sv_conductor
    where _estado = 'A'  and id_conductor <> varCodigo
    and (TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) or TRIM(UPPER(dni)) = TRIM(UPPER(varDni)));
    
    if varExiste <= 0 then 
      update _sv_conductor set      
      nombre       = UPPER(varNombre),       
      dni          = varDni, 
      brevete      = UPPER(varBrevete), 
      telefono     = varTelefono,
      monto        = varCosto,
      estado       = varEstado,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_conductor = varCodigo;
    else
      set varError = CONCAT('EL CONDUCTOR ', varNombre, ' \nO EL DNI ', varDni, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;		
	end if;
  SELECT varError;
END;