call spMante_Comision_Proveedor('NEW', '2013', '12', 2, 26, 1, 2, 1);
call spMante_Comision_Proveedor('NEW', '2013', '12', 2, 13, 1, 2, 1);

DROP PROCEDURE IF EXISTS spMante_Comision_Proveedor;
CREATE PROCEDURE spMante_Comision_Proveedor(
	varOpcion     varchar(10),
	varAnio       varchar(4),
	varMes        varchar(2),
  varEmpresa    int,
  varProveedor  int,
  varLista      int,
  varComision   double,
	varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
  DECLARE varDPro, varDTip, varDMes varchar(80) default '';
  
  select nombre into varDPro from _sv_proveedor     where id_proveedor = varProveedor;
  select nombre into varDTip from _sv_lista where id_lista = varLista and id_empresa = varEmpresa;
  select spFuncion_NombreMes(varMes) into varDMes;
  
  if varOpcion='NEW' then
    select count(*) INTO varExiste from _sv_proveedor_comision 
    where id_anio     = varAnio
    and id_mes        = varMes
    and id_empresa    = varEmpresa
    and id_proveedor  = varProveedor
    and id_lista      = varLista
    and _estado       = 'A';
    
    if varExiste <= 0 then 
      INSERT INTO _sv_proveedor_comision (id_anio, id_mes, id_empresa, id_proveedor, id_lista, peso, 
                  _date_create, _date_update, _user_create, _user_update) 
      values (varAnio, varMes, varEmpresa, varProveedor, varLista, varComision, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA COMISION PARA\n',
                            'Anio : ', varAnio, '\n',
                            'Mes : ', varMes, ' - ', UPPER(varDMes), '\n',
                            'Proveedor : ', varProveedor, ' - ', UPPER(varDPro), '\n',
                            'Lista : ', varLista, ' - ', UPPER(varDTip));
    end if;
	else
    update _sv_proveedor_comision 
    set peso     = varComision,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_anio     = varAnio
    and id_mes        = varMes
    and id_empresa    = varEmpresa
    and id_proveedor  = varProveedor
    and id_lista      = varLista;
	end if;
  select varError;
END;