call spMante_Cargo_Trabajador('EDIT', 2, 'ANALISTA DE SISTEMAS', 1, 1);

DROP PROCEDURE IF EXISTS spMante_Cargo_Trabajador;
CREATE PROCEDURE spMante_Cargo_Trabajador(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
  varArea     int,
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _srh_cargo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_cargo),0)+1 INTO varCodigo FROM _srh_cargo;
      INSERT INTO _srh_cargo (id_cargo, id_area, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varArea, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL CARGO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _srh_cargo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_cargo <> varCodigo;
    if varExiste <= 0 then 
      update _srh_cargo set
      nombre        = UPPER(varNombre),
      id_area       = varArea,
      _date_update  = NOW(),
      _user_update  = varUsuario
      where id_cargo = varCodigo;
    else
      set varError = CONCAT('EL CARGO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;