CALL spMante_Bonificacion_Aplicar(68306,1);

DROP PROCEDURE IF EXISTS spMante_Bonificacion_Aplicar;
CREATE PROCEDURE spMante_Bonificacion_Aplicar(
	varPedido   int,	
	varUsuario  int
)
BEGIN
  DECLARE varCliente, varEmpresa  int;
  DECLARE varRuta     varchar(10);
  DECLARE varLista    int;
  DECLARE varFecha    date;
  
  select P.id_empresa, P.id_cliente, P.id_ruta, P.id_lista, P.fecha_pedido
  into varEmpresa, varCliente, varRuta, varLista, varFecha
  from _sv_pedido P
  where id_pedido = varPedido
  and _estado = 'A';
 
  INSERT INTO _sv_pedido_detalle
  SELECT varPedido as id_pedido, id_producto, id_um, 'B' as id_tipo,
  TRUNCATE(sum(cantidad),0) as cantidad_ped,
  TRUNCATE(sum(cantidad),0) as cantidad_ate,
  0 as precio,  0 as subtotal,  0 as igv,  0 as total,
  NULL, NULL,
  NOW() as _date_create,  NOW() as _date_update,
  varUsuario as _user_create,  varUsuario as _user_update,  'A' as _estado
  FROM
    (
    -- LISTADO DE BONIFICACIONES MASIVAS
    SELECT Y.id_producto, Y.id_um, sum(Y.cantidad*X.NUMBONIF) as cantidad  
    FROM
      (
      select id_empresa, id_bonif, 
      MIN(TRUNCATE(CASE WHEN IFNULL(cantidad_ped,0)>= minimo 
                        THEN CASE WHEN IFNULL(cantidad_ped,0)<= maximo 
                                  THEN IFNULL(cantidad_ped,0)
                                  ELSE maximo
                             END
                   END/IFNULL(cantidad,0),0)) AS NUMBONIF
      from
        (
        select B.id_empresa, B.id_bonif, V.id_producto, V.id_um,
        V.cantidad, V.minimo, V.maximo
        from _sv_bonificacion_venta V
        inner join _sv_bonificacion B  ON B.id_empresa = V.id_empresa AND B.id_bonif = V.id_bonif
        where V._estado  = 'A' and B._estado = 'A'
        and B.fecha_fin >= varFecha
        and B.fecha_ini <= varFecha
        and B.id_empresa = varEmpresa
        and B.id_tipo_bonif = 'M'        
        ) A
      left join
        (
        select id_producto, id_um, cantidad_ped
        from _sv_pedido_detalle
        where id_pedido = varPedido
        ) B
      ON A.id_producto = B.id_producto and A.id_um = B.id_um
      GROUP BY id_empresa, id_bonif
      HAVING MIN(TRUNCATE(CASE WHEN IFNULL(cantidad_ped,0)>= minimo 
                               THEN CASE WHEN IFNULL(cantidad_ped,0)<= maximo 
                                         THEN IFNULL(cantidad_ped,0)
                                         ELSE maximo
                                    END
                          END/IFNULL(cantidad,0),0)) > 0
      ) X
    LEFT JOIN
      (
      select id_empresa, id_bonif, id_producto, id_um, cantidad
      from _sv_bonificacion_bonif
      where _estado  = 'A'
      and id_empresa = varEmpresa
      ) Y
    ON X.id_empresa = Y.id_empresa and X.id_bonif = Y.id_bonif
    group by Y.i