call spMante_Asignacion('NEW', NULL, 'nueva lista', NULL, 1);

DROP PROCEDURE IF EXISTS spMante_Asignacion;
CREATE PROCEDURE spMante_Asignacion(
	varOpcion     varchar(10),
	varCodigo     int,
	varFecha      date,
  varVehiculo   int,
  varConductor  int,
  varMonVeh     double,
  varMonCon     double,
	varUsuario    int
)
BEGIN
  if varOpcion='NEW' then    
    SELECT ifnull(max(id_asignacion),0)+1 INTO varCodigo FROM _sv_asignacion;
    INSERT INTO _sv_asignacion (id_asignacion, id_fecha, id_vehiculo, id_conductor, monto_vehiculo, monto_conductor, 
                                _date_create, _date_update, _user_create, _user_update) 
    VALUES (varCodigo, varFecha, varVehiculo, varConductor, varMonVeh, varMonCon, 
           NOW(),NOW(), varUsuario, varUsuario);
	else    
    update _sv_asignacion set
    id_fecha        = varFecha,
    id_vehiculo     = varVehiculo, 
    id_conductor    = varConductor, 
    monto_vehiculo  = varMonVeh, 
    monto_conductor = varMonCon
    where id_asignacion = varCodigo;
  end if;
  select varCodigo;
END;