Call spMante_Agencia('NEW', NULL, 'NEGOCIOS SEOR as CAUTIVO S.R.L.', '20124589654', 'LAS AMERICAS 142 - CHICLAYO', 1);

DROP PROCEDURE IF EXISTS spMante_Agencia;
CREATE PROCEDURE spMante_Agencia(
	varOpcion   varchar(10),
	varCodigo   int,
	varEmpresa  int,
  varNombre   varchar(100),
  varAbrev    varchar(20),
  varDirecc   varchar(100),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	if varOpcion='NEW' then
    -- Validamos que el nombre dLA AGENCIA no exista
    select count(*) INTO varExiste  from _srh_agencia 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A'
    and id_empresa = varEmpresa;
    if varExiste > 0 then
      set varError = CONCAT('LA AGENCIA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA PARA ESTA EMPRESA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_agencia),0)+1 INTO varCodigo FROM _srh_agencia;
      INSERT INTO _srh_agencia (id_agencia, id_empresa, nombre, abrev, direccion, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varEmpresa,UPPER(varNombre), UPPER(varAbrev), UPPER(varDirecc), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    -- Validamos que el razon social de la empresa no exista
    select count(*) INTO varExiste  from _srh_agencia 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_agencia <> varCodigo and id_empresa = (select id_empresa from _srh_agencia where id_agencia=varCodigo);
    if varExiste > 0 then
      set varError = CONCAT('LA AGENCIA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN ESTA EMPRESA\n');
    end if;
    
    if varError = '' then 
      update _srh_agencia set
      nombre    = UPPER(varNombre),
      abrev     = UPPER(varAbrev),
      direccion = UPPER(varDirecc),
      _date_update = NOW(),
      _user_update = varUsuario
      where id_agencia = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;