select spFuncion_Existe_Registro('_sv_vendedor', '5');

DROP FUNCTION IF EXISTS spFuncion_Existe_Registro;
CREATE FUNCTION spFuncion_Existe_Registro (
  varTabla  varchar(50),
  varValor  varchar(50)
  ) RETURNS TEXT
BEGIN 
  DECLARE varExiste int default 0;
  DECLARE varError text default 'OK';
  DECLARE varTabla2 text default '';
  
  CASE lower(varTabla)
  WHEN '_sv_empresa' THEN  
      select count(id_empresa)  into varExiste
      from _sv_empresa
      where _estado = 'A'
      and id_empresa = varValor;
      set varTabla2 = "EMPRESAS";
    
  WHEN '_srh_agencia' THEN
      select count(id_agencia)  into varExiste
      from _srh_agencia
      where _estado = 'A'
      and id_agencia = varValor;
      set varTabla2 = "AGENCIAS";
  WHEN '_sv_almacen' THEN
      select count(id_almacen)  into varExiste
      from _sv_almacen
      where _estado = 'A'
      and id_almacen = varValor;
      set varTabla2 = "ALMACENES";
  WHEN '_sv_punto_venta' THEN
      select count(id_punto_venta)  into varExiste
      from _sv_punto_venta
      where _estado = 'A'
      and id_punto_venta = varValor;
      set varTabla2 = "PUNTOS DE VENTA";
  WHEN '_sv_tipo_doc_venta' THEN
      select count(id_tipo_doc)  into varExiste
      from _sv_tipo_doc_venta
      where _estado = 'A'
      and id_tipo_doc = varValor;
      set varTabla2 = "TIPOS DE DOCUMENTO DE VENTA";
  WHEN '_sv_tipo_doc_compra' THEN
      select count(id_tipo_doc)  into varExiste
      from _sv_tipo_doc_compra
      where _estado = 'A'
      and id_tipo_doc = varValor;
      set varTabla2 = "TIPOS DE DOCUMENTO DE COMPRA";
  WHEN '_sv_tipo_condicion' THEN
      select count(id_condicion)  into varExiste
      from _sv_tipo_condicion
      where _estado = 'A'
      and id_condicion = varValor;
      set varTabla2 = "CONDICIONES DE PAGO";
  WHEN '_sv_cliente' THEN
      select count(id_cliente)  into varExiste
      from _sv_cliente
      where _estado = 'A'
      and id_cliente = varValor;
      set varTabla2 = "CLIENTES";
  WHEN '_sv_ruta' THEN
      select count(id_ruta)  into varExiste
      from _sv_ruta
      where _estado = 'A'
      and id_ruta = varValor;
      set varTabla2 = "RUTAS";
  WHEN '_sv_vendedor' THEN
      select count(L.id_trabajador)  into varExiste
      from _sv_trabajador_lista L
      inner join _sv_trabajador T on L.id_trabajador=T.id_trabajador
      where T._estado = 'A'
      and L.id_tipo_trabajador = 'VEN'
      and T.id_trabajador = varValor;
      set varTabla2 = "VENDEDORES";
  ELSE
      set varExiste = 0;
  END CASE;

  if varExiste <= 0 then
    set varError = CONCAT("NO EXISTE EL VALOR ", varValor, " EN LA TABLA ", varTabla2);
  end if;
  RETURN varError; 
END;