<?php
session_start();
error_reporting(E_ALL ^ E_NOTICE);
require_once('./includes/config.php');
define('ROOT_PATH',str_replace(array('/'.$CONFIG[ROOT_DIR],"\\"),array("","/"),dirname(__FILE__)));

require_once(ROOT_PATH . "/includes/function.default.php");

require_once(ROOT_PATH . "/includes/class.mysql.php");
require_once(ROOT_PATH . "/includes/config.db.php");
$db=new Mysql($db_host,$db_user,$db_pwd,$db_name,true);

include(ROOT_PATH . "/includes/class.page.php");

if(!get_magic_quotes_gpc()){
	$_POST=addslashes_array($_POST);
	$_GET=addslashes_array($_GET);
	}

require_once(ROOT_PATH . "/includes/smarty/Smarty.class.php");

$smarty=new Smarty();
$smarty->template_dir = ROOT_PATH . "/{$CONFIG['ROOT_DIR']}/templates/" . $CONFIG['TEMPLATE'] ."/";
$smarty->compile_dir = ROOT_PATH . "/templates_c/{$CONFIG[ROOT_DIR]}/";
$smarty->config_dir = ROOT_PATH . "/configs/";
$smarty->cache_dir = ROOT_PATH . "/cache/";
$smarty->caching = false;
$smarty->cache_lifetime = 60 * 60 * 24;
$smarty->left_delimiter = '<{';
$smarty->right_delimiter = '}>';
$smarty->debugging = false;     //用于调试程序

$smarty->assign('ROOT_PATH',$CONFIG['ROOT_PATH'].'/'.$CONFIG['ROOT_DIR']);
$smarty->assign('TEMPLATE',$CONFIG['TEMPLATE']);

//载入语言包
$language_file = ROOT_PATH . "/{$CONFIG[ROOT_DIR]}/language/".$CONFIG['lang'].".php";
if(file_exists($language_file)){
	require_once($language_file);
	}else{
	require_once(ROOT_PATH . "/{$CONFIG[ROOT_DIR]}/language/en.php");
	}
$smarty->assign('LANG',$LANG);
?>