<?php
include_once '../conexion.php';

function insertVenta($conn, $data)
{
    // ... (extract data)

    // Insert into ventas table
    $queryCabecera = "INSERT INTO ventas(empresa_id, docfiscal_id, nserie, ndocumento, fecha_emision, fecha_traslado, fecha_vencimiento, 
        razon_social, direccion, tipo_docidentidad, documento_identidad, nro_dias, moneda, tipo_cambio, afecto_igv, 
        porcentaje_igv, igv, afecto_dscto, porcentaje_dscto, descuento, afecto_percepcion, porcentaje_percepcion, percepcion,
        afecto, inafecto, exonerado, total, guia_remision, cancelado, icbp, gratuitas, afecta_kardex, afecta_caja, periodo, mes, 
        formapago_id, caja_id, cliente_id, empleado_id, sucursal_id, observacion, acuenta, servicio, zona_id)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    $stmtCabecera = mysqli_prepare($conn, $queryCabecera);

    if ($stmtCabecera) {
        mysqli_stmt_bind_param(
            $stmtCabecera,
            'ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss',
            $cEmpresa_Id, $cDocFiscal_id, $cNSerie, $cNDocumento, $cFechaEmision, $cFechaTraslado, $cFechaVencimiento,
            $cNombre, $cDireccion, $cTipDocIdent, $cDocIdentidad, $cNDias, $cMoneda, $cTipoCambio, $cAfectoIgv,
            $cP_Igv, $cIgv, $cAfectDscto, $cP_Dscto, $cDescuento, $cAfectoPercepcion, $cP_Percepcion, $cPercepcion,
            $cAfecto, $cInafecto, $cExonerado, $cTotal, $cGuiaRemision, $cCancelado, $cIcbp, $cGratuitas, $cAfectaKardex,
            $cAfectaCaja, $cPeriodo, $cMes, $cFormaPago_Id, $cCaja_Id, $cCliente_Id, $cEmpleado_id, $cSucursal_Id,
            $cObservacion, $cAcuenta, $cServicio, $cZona_Id
        );

        $resultadoCabecera = mysqli_stmt_execute($stmtCabecera);
        mysqli_stmt_close($stmtCabecera);

        if (!$resultadoCabecera) {
            throw new Exception("Error executing statement for cabecera: " . mysqli_error($conn));
        }

        $idVenta = mysqli_insert_id($conn);

        // Insert into detalle_venta table
        foreach ($data['detalle'] as $detalle) {
            $queryDetalle = "INSERT INTO detalle_venta(venta_id, producto_id, cantidad, precio_unitario, subtotal)
                VALUES (?, ?, ?, ?, ?)";
            $stmtDetalle = mysqli_prepare($conn, $queryDetalle);

            if ($stmtDetalle) {
                mysqli_stmt_bind_param(
                    $stmtDetalle,
                    'sssss',
                    $idVenta, $detalle['producto_id'], $detalle['cantidad'], $detalle['precio_unitario'], $detalle['subtotal']
                );

                $resultadoDetalle = mysqli_stmt_execute($stmtDetalle);
                mysqli_stmt_close($stmtDetalle);

                if (!$resultadoDetalle) {
                    throw new Exception("Error executing statement for detalle: " . mysqli_error($conn));
                }
            } else {
                throw new Exception("Error preparing statement for detalle: " . mysqli_error($conn));
            }
        }

        return $idVenta;
    } else {
        throw new Exception("Error preparing statement for cabecera: " . mysqli_error($conn));
    }
}

// ... (similar improvements for other operations)

mysqli_autocommit($conn, false);
$transaccionExitosa = true;
$errorMensaje = "";

try {
    // ... (extract data)

    if ($cEstado == 'NUEVO') {
        $idVenta = insertVenta($conn, $data);
        updateSeries($conn, $cEmpresa_Id, $cSucursal_Id, $cNSerie);
        // ... (similar improvements for other operations)
    }

    if ($transaccionExitosa) {
        mysqli_commit($conn);
    } else {
        mysqli_rollback($conn);
    }
} catch (Exception $e) {
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
    mysqli_rollback($conn);
}
?>




/*// Function to insert data into the ventas table
function insertVenta($conn, $data)
{
    // ... (extract data)

    $queryCabecera = "INSERT INTO ventas(empresa_id, docfiscal_id, nserie, ndocumento, fecha_emision, fecha_traslado, fecha_vencimiento, 
        razon_social, direccion, tipo_docidentidad, documento_identidad, nro_dias, moneda, tipo_cambio, afecto_igv, 
        porcentaje_igv, igv, afecto_dscto, porcentaje_dscto, descuento, afecto_percepcion, porcentaje_percepcion, percepcion,
        afecto, inafecto, exonerado, total, guia_remision, cancelado, icbp, gratuitas, afecta_kardex, afecta_caja, periodo, mes, 
        formapago_id, caja_id, cliente_id, empleado_id, sucursal_id, observacion, acuenta, servicio, zona_id)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    $stmt = mysqli_prepare($conn, $queryCabecera);

    if ($stmt) {
        mysqli_stmt_bind_param(
            $stmt,
            'ssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss',
            $cEmpresa_Id, $cDocFiscal_id, $cNSerie, $cNDocumento, $cFechaEmision, $cFechaTraslado, $cFechaVencimiento,
            $cNombre, $cDireccion, $cTipDocIdent, $cDocIdentidad, $cNDias, $cMoneda, $cTipoCambio, $cAfectoIgv,
            $cP_Igv, $cIgv, $cAfectDscto, $cP_Dscto, $cDescuento, $cAfectoPercepcion, $cP_Percepcion, $cPercepcion,
            $cAfecto, $cInafecto, $cExonerado, $cTotal, $cGuiaRemision, $cCancelado, $cIcbp, $cGratuitas, $cAfectaKardex,
            $cAfectaCaja, $cPeriodo, $cMes, $cFormaPago_Id, $cCaja_Id, $cCliente_Id, $cEmpleado_id, $cSucursal_Id,
            $cObservacion, $cAcuenta, $cServicio, $cZona_Id
        );

        $resultadoCabecera = mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);

        if (!$resultadoCabecera) {
            throw new Exception("Error executing statement: " . mysqli_error($conn));
        }

        return mysqli_insert_id($conn);
    } else {
        throw new Exception("Error preparing statement: " . mysqli_error($conn));
    }
}

// Function to update series_sucursal table
function updateSeries($conn, $cEmpresa_Id, $cSucursal_Id, $cNSerie)
{
    $query = "SELECT numero FROM series_sucursal WHERE empresa_id = ? AND sucursal_id = ? AND nserie = ? FOR UPDATE";
    $stmt = mysqli_prepare($conn, $query);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'sss', $cEmpresa_Id, $cSucursal_Id, $cNSerie);
        $result = mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);

        if (!$result) {
            throw new Exception("Error executing statement for series update: " . mysqli_error($conn));
        }

        $queryUPD = "UPDATE series_sucursal SET numero = numero + 1 WHERE empresa_id = ? AND sucursal_id = ? AND nserie = ?";
        $stmtUPD = mysqli_prepare($conn, $queryUPD);

        if ($stmtUPD) {
            mysqli_stmt_bind_param($stmtUPD, 'sss', $cEmpresa_Id, $cSucursal_Id, $cNSerie);
            $resultUPD = mysqli_stmt_execute($stmtUPD);
            mysqli_stmt_close($stmtUPD);

            if (!$resultUPD) {
                throw new Exception("Error updating series: " . mysqli_error($conn));
            }
        } else {
            throw new Exception("Error preparing statement for series update: " . mysqli_error($conn));
        }
    } else {
        throw new Exception("Error preparing statement for series selection: " . mysqli_error($conn));
    }
}

mysqli_autocommit($conn, false);
$transaccionExitosa = true;
$errorMensaje = "";

try {
    // ... (extract data)

    if ($cEstado == 'NUEVO') {
        $idVenta = insertVenta($conn, $data);
        updateSeries($conn, $cEmpresa_Id, $cSucursal_Id, $cNSerie);
        // ... (similar improvements for other operations)
    }

    if ($transaccionExitosa) {
        mysqli_commit($conn);
    } else {
        mysqli_rollback($conn);
    }
} catch (Exception $e) {
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
    mysqli_rollback($conn);
}*/

