<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() != JSON_ERROR_NONE || !is_array($datos)) {
    print_json(array('ESTADO' => '0', 'MENSAJE' => 'Error en el formato JSON'));
    exit;
}

//print_r($datos);

// Aseg¨²rate de que hay suficientes elementos en $datos antes de preparar la consulta
if (count($datos) !== 26) {
    print_json(array('ESTADO' => '0', 'MENSAJE' => 'N¨²mero incorrecto de par¨¢metros'));
    exit;
}

$sql = $conn->prepare("CALL IM_MovCaja(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

if (!$sql) {
    print_json(array('ESTADO' => '0', 'MENSAJE' => 'Error al preparar la consulta'));
    exit;
}

$sql->bind_param("ssisissssisssisissssssiiis", ...$datos);

$sql->execute();

if ($sql->errno) {
    print_json(array('ESTADO' => '0', 'MENSAJE' => 'Error al ejecutar la consulta: ' . $sql->error));
    exit;
}

$rowsAffected = $sql->affected_rows;

/*if ($datos[25] == "NUEVO") {
    $newRecordId = $sql->insert_id;
    $resultado = array();
    if ($rowsAffected > 0) {
        $mensaje = $result->fetch_assoc();
        $resultado['ESTADO'] = "1";
        $resultado['ID'] = $newRecordId;
        $resultado['MENSAJE'] = "LA INFORMACION SE GUARDÓ CORRECTAMENTE";
    } else {
        $resultado['ESTADO'] = "0";
        $resultado['ID'] = "0";
        $resultado['MENSAJE'] = "ERROR AL GUARDAR LA INFORMACIÓN: " . mysqli_error($conn);
    }
} else {
    $resultado = array();
    $resultado['ESTADO'] = "1";
    $resultado['MENSAJE'] = "LA INFORMACION SE ACTUALIZÓ CORRECTAMENTE";
}*/

if ($rowsAffected > 0) {
    // Se insertó o actualizó al menos un registro
    print_json(array('ESTADO' => '1', 'MENSAJE' => 'Registro guardado/actualizado con éxito'));
} else {
    // No se insertó ni actualizó ningún registro
    print_json(array('ESTADO' => '0', 'MENSAJE' => 'No se realizaron cambios en la base de datos'));
}

// Devolver la respuesta JSON
//print_json($resultado);

// Cerrar la conexi¨®n a la base de datos
mysqli_close($conn);

function print_json($data) {
    header("HTTP/1.1");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($data, JSON_PRETTY_PRINT);
}
?>
